/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.dialog.VWWorkClassProxy;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.IVWParamExpressionCellEditorTableModel;
import filenet.vw.toolkit.design.property.tables.IVWWSParamExpressionCellEditorTableModel;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWExpressionBuilderDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.TableCellEditor;

public class VWParamExpressionCellEditor
implements TableCellEditor,
KeyListener,
MouseListener,
ActionListener,
IVWPropertyChangeSource {
    protected EventListenerList m_listenerList = null;
    protected transient ChangeEvent m_changeEvent = null;
    protected VWAuthPropertyData m_authPropertyData = null;
    protected Vector m_changedItems = null;
    protected JComboBox m_comboBox = null;
    protected BasicComboBoxEditor m_comboBoxEditor = null;
    protected JTable m_table = null;
    protected int m_nClickCountToStart = 1;
    protected String m_currentValue = null;
    protected String m_paramName = null;
    protected int m_paramDataType = -1;
    protected boolean m_paramIsArray = false;

    public VWParamExpressionCellEditor(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.m_listenerList = new EventListenerList();
        this.m_comboBox = new JComboBox(new DefaultComboBoxModel());
        this.m_comboBox.setRenderer(new VWLabelListCellRenderer());
        this.m_comboBox.addActionListener(this);
        this.m_comboBox.setEditable(true);
        this.m_comboBoxEditor = new BasicComboBoxEditor();
        this.m_comboBoxEditor.getEditorComponent().addKeyListener(this);
        this.m_comboBox.setEditor(this.m_comboBoxEditor);
    }

    public static String getInitialFieldValue(int nFieldType, boolean bIsArray) throws VWException {
        switch (nFieldType) {
            case 32: {
                VWAttachment vwAtt = new VWAttachment();
                if (bIsArray) {
                    return "{\"" + vwAtt.toString() + "\"}";
                }
                return "\"" + vwAtt.toString() + "\"";
            }
            case 4: {
                if (bIsArray) {
                    return "{true}";
                }
                return "true";
            }
            case 8: {
                if (bIsArray) {
                    return "{0.0}";
                }
                return "0.0";
            }
            case 512: {
                VWGuid vwGuid = new VWGuid();
                if (bIsArray) {
                    return "{\"" + vwGuid.toString() + "\"}";
                }
                return "\"" + vwGuid.toString() + "\"";
            }
            case 1: {
                if (bIsArray) {
                    return "{0}";
                }
                return "0";
            }
            case 2: 
            case 64: 
            case 128: {
                if (bIsArray) {
                    return "{\"\"}";
                }
                return "\"\"";
            }
            case 16: {
                if (bIsArray) {
                    return "{systemtime()}";
                }
                return "systemtime()";
            }
        }
        return null;
    }

    public int getClickCountToStart() {
        return this.m_nClickCountToStart;
    }

    public void setClickCountToStart(int nCount) {
        this.m_nClickCountToStart = nCount;
    }

    public Component getComponent() {
        return this.m_comboBox;
    }

    public boolean startCellEditing(EventObject anEvent) {
        return true;
    }

    public void addCellEditorListener(CellEditorListener listener) {
        this.m_listenerList.add(CellEditorListener.class, listener);
    }

    public void cancelCellEditing() {
        if (this.m_table != null) {
            this.m_table.removeMouseListener(this);
            this.m_table = null;
        }
        this.fireEditingCanceled();
    }

    public Object getCellEditorValue() {
        return this.m_currentValue;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return !(anEvent instanceof MouseEvent) || ((MouseEvent)anEvent).getClickCount() >= this.m_nClickCountToStart;
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        this.m_listenerList.remove(CellEditorListener.class, listener);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        boolean retValue = true;
        if (this.isCellEditable(anEvent) && (anEvent == null || anEvent instanceof MouseEvent && ((MouseEvent)anEvent).getClickCount() >= this.m_nClickCountToStart)) {
            retValue = this.startCellEditing(anEvent);
        }
        return retValue;
    }

    public boolean stopCellEditing() {
        if (this.m_table != null) {
            this.m_table.removeMouseListener(this);
            this.m_table = null;
        }
        this.m_currentValue = (String)this.m_comboBox.getSelectedItem();
        if (VWStringUtils.compare(this.m_currentValue, VWResource.s_buildExpression) == 0 || VWStringUtils.compare(this.m_currentValue, VWResource.s_createField.toString(this.m_paramName)) == 0 || VWStringUtils.compare(this.m_currentValue, VWResource.s_undefined) == 0) {
            this.m_currentValue = "";
        }
        this.fireEditingStopped();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int nRow, int nColumn) {
        int nMode = 3;
        this.m_paramName = null;
        this.m_paramDataType = 4;
        this.m_paramIsArray = false;
        if (table != null) {
            VWMLABase paramDef;
            Object tableModel;
            this.m_table = table;
            this.m_table.addMouseListener(this);
            if (table.getModel() instanceof IVWParamExpressionCellEditorTableModel) {
                tableModel = (IVWParamExpressionCellEditorTableModel)((Object)this.m_table.getModel());
                paramDef = tableModel.getItemAt(nRow);
                if (paramDef != null) {
                    this.m_paramName = ((VWParameterDefinition)paramDef).getName();
                    this.m_paramDataType = ((VWParameterDefinition)paramDef).getDataType();
                    this.m_paramIsArray = ((VWParameterDefinition)paramDef).getIsArray();
                    nMode = ((VWParameterDefinition)paramDef).getMode();
                } else {
                    this.m_paramName = "";
                    this.m_paramDataType = tableModel.getParameterType(nRow);
                    this.m_paramIsArray = tableModel.getIsArray(nRow);
                    nMode = tableModel.getMode(nRow);
                }
            } else if (table.getModel() instanceof IVWWSParamExpressionCellEditorTableModel) {
                tableModel = (IVWWSParamExpressionCellEditorTableModel)((Object)this.m_table.getModel());
                paramDef = tableModel.getItemAt(nRow);
                if (paramDef != null) {
                    this.m_paramName = ((VWWebServiceParameterDefinition)paramDef).getName();
                    this.m_paramDataType = ((VWWebServiceParameterDefinition)paramDef).getDataType();
                    this.m_paramIsArray = ((VWWebServiceParameterDefinition)paramDef).getIsArray();
                    nMode = ((VWWebServiceParameterDefinition)paramDef).getMode();
                } else {
                    this.m_paramName = "";
                    this.m_paramDataType = tableModel.getParameterType(nRow);
                    this.m_paramIsArray = tableModel.getIsArray(nRow);
                    nMode = tableModel.getMode(nRow);
                }
            }
        }
        this.m_currentValue = value != null && value instanceof String && ((String)value).length() > 0 ? (String)value : null;
        if (this.m_authPropertyData == null) return this.m_comboBox;
        if (this.m_comboBox == null) return this.m_comboBox;
        try {
            try {
                VWFieldDefinition fieldDef;
                this.m_comboBox.removeActionListener(this);
                this.m_comboBox.removeAllItems();
                DefaultComboBoxModel cbModel = (DefaultComboBoxModel)this.m_comboBox.getModel();
                boolean bFound = false;
                if (this.m_paramName != null && this.m_paramName.length() > 0 && VWFieldType.isValidName(this.m_paramName)) {
                    fieldDef = this.m_authPropertyData.getField(this.m_paramName);
                    if (fieldDef != null) {
                        if (fieldDef.getFieldType() == this.m_paramDataType && this.m_currentValue == null) {
                            this.m_currentValue = this.m_paramName;
                            bFound = true;
                        }
                    } else {
                        cbModel.addElement(VWResource.s_createField.toString(this.m_paramName));
                        if (this.m_currentValue != null && VWStringUtils.compare(this.m_paramName, this.m_currentValue) == 0) {
                            bFound = true;
                        }
                    }
                }
                if (nMode == 1) {
                    cbModel.addElement(VWResource.s_buildExpression);
                }
                if (this.m_currentValue != null && !bFound) {
                    fieldDef = this.m_authPropertyData.getField(this.m_currentValue);
                    if (fieldDef == null || fieldDef != null && (fieldDef.getFieldType() != this.m_paramDataType || fieldDef.isArray() != this.m_paramIsArray)) {
                        cbModel.addElement(this.m_currentValue);
                    }
                } else if (this.m_currentValue == null) {
                    cbModel.addElement(VWResource.s_undefined);
                    this.m_currentValue = VWResource.s_undefined;
                }
                VWFieldDefinition[] fieldDefs = this.m_authPropertyData.getFields();
                if (fieldDefs != null && fieldDefs.length > 0) {
                    Vector<String> nameList = new Vector<String>();
                    for (int i = 0; i < fieldDefs.length; ++i) {
                        if (fieldDefs[i].getFieldType() != this.m_paramDataType || this.m_paramIsArray && !fieldDefs[i].isArray()) continue;
                        nameList.addElement(fieldDefs[i].getName());
                    }
                    if (nameList.size() > 0) {
                        Object[] fieldNames = new String[nameList.size()];
                        nameList.copyInto(fieldNames);
                        VWQubbleSort.sort(fieldNames);
                        for (int i = 0; i < fieldNames.length; ++i) {
                            cbModel.addElement(fieldNames[i]);
                        }
                    }
                }
                if (this.m_currentValue == null || this.m_currentValue != null && this.m_currentValue.length() == 0) {
                    this.m_comboBox.setSelectedIndex(0);
                }
                this.m_comboBox.setSelectedItem(this.m_currentValue);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var14_17 = null;
                this.m_comboBox.addActionListener(this);
                if (table == null) return this.m_comboBox;
                this.m_comboBox.setComponentOrientation(table.getComponentOrientation());
                if (!(this.m_comboBoxEditor.getEditorComponent() instanceof JTextField)) return this.m_comboBox;
                ((JTextField)this.m_comboBoxEditor.getEditorComponent()).setComponentOrientation(table.getComponentOrientation());
                return this.m_comboBox;
            }
            Object var14_16 = null;
            this.m_comboBox.addActionListener(this);
            if (table == null) return this.m_comboBox;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            this.m_comboBox.addActionListener(this);
            if (table == null) throw throwable;
            this.m_comboBox.setComponentOrientation(table.getComponentOrientation());
            if (!(this.m_comboBoxEditor.getEditorComponent() instanceof JTextField)) throw throwable;
            ((JTextField)this.m_comboBoxEditor.getEditorComponent()).setComponentOrientation(table.getComponentOrientation());
            throw throwable;
        }
        this.m_comboBox.setComponentOrientation(table.getComponentOrientation());
        if (!(this.m_comboBoxEditor.getEditorComponent() instanceof JTextField)) return this.m_comboBox;
        ((JTextField)this.m_comboBoxEditor.getEditorComponent()).setComponentOrientation(table.getComponentOrientation());
        return this.m_comboBox;
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
        if (event.getKeyChar() == '\n') {
            this.stopCellEditing();
        }
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.getSource().equals(this.m_table)) {
            this.stopCellEditing();
        }
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src.equals(this.m_comboBox)) {
            String selectedItem = (String)this.m_comboBox.getSelectedItem();
            if (VWStringUtils.compare(selectedItem, VWResource.s_buildExpression) == 0) {
                this.m_comboBox.setEnabled(false);
                this.displayExpressionBuilderDialog();
                this.m_comboBox.setEnabled(true);
            } else if (VWStringUtils.compare(selectedItem, VWResource.s_createField.toString(this.m_paramName)) == 0) {
                this.m_comboBox.setEnabled(false);
                this.createField();
                this.m_comboBox.setEnabled(true);
            }
            this.stopCellEditing();
        }
    }

    public void notifyPropertyChange() {
    }

    public Vector getItemsChanged() {
        return this.m_changedItems;
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.m_changeEvent == null) {
                this.m_changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingStopped(this.m_changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.m_changeEvent == null) {
                this.m_changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingCanceled(this.m_changeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void displayExpressionBuilderDialog() {
        block9: {
            try {
                VWExpressionBuilderDialog expressionDialog;
                int nFlags = 2703;
                int nOrientation = 1;
                String value = this.m_currentValue;
                if (VWStringUtils.compare(value, VWResource.s_undefined) == 0) {
                    value = "";
                }
                if ((expressionDialog = new VWExpressionBuilderDialog(this.m_authPropertyData.getMainContainer(), (IVWPropertyData)this.m_authPropertyData, null, value, nFlags, nOrientation)) == null) break block9;
                VWWorkClassProxy workClassProxy = new VWWorkClassProxy(this.m_authPropertyData.getWorkflowDefinition().getName(), 0, this.m_authPropertyData);
                expressionDialog.setWorkClassProxy(workClassProxy);
                expressionDialog.setValueInfo(this.m_paramName, this.m_paramDataType, this.m_paramIsArray);
                expressionDialog.init();
                expressionDialog.setVisible(true);
                if (expressionDialog.getDialogResult() == 0) {
                    this.m_currentValue = expressionDialog.getExpressionString();
                }
                try {
                    try {
                        this.m_comboBox.removeActionListener(this);
                        DefaultComboBoxModel cbModel = (DefaultComboBoxModel)this.m_comboBox.getModel();
                        if (cbModel.getIndexOf(this.m_currentValue) == -1) {
                            cbModel.addElement(this.m_currentValue);
                        }
                        this.m_comboBox.setSelectedItem(this.m_currentValue);
                    }
                    catch (Exception ex1) {
                        VWDebug.logException(ex1);
                        Object var8_10 = null;
                        this.m_comboBox.addActionListener(this);
                        break block9;
                    }
                    Object var8_9 = null;
                    this.m_comboBox.addActionListener(this);
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    this.m_comboBox.addActionListener(this);
                    throw throwable;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createField() {
        block16: {
            try {
                boolean bFieldIsArray = this.m_paramIsArray;
                if (this.m_paramDataType == 64) {
                    bFieldIsArray = true;
                }
                String strFieldValue = VWParamExpressionCellEditor.getInitialFieldValue(this.m_paramDataType, bFieldIsArray);
                VWFieldDefinition fieldDef = this.m_authPropertyData.getWorkflowDefinition().createFieldUsingString(this.m_paramName, strFieldValue, this.m_paramDataType, bFieldIsArray);
                if (fieldDef == null) break block16;
                this.m_currentValue = this.m_paramName;
                try {
                    try {
                        this.m_comboBox.removeActionListener(this);
                        DefaultComboBoxModel cbModel = (DefaultComboBoxModel)this.m_comboBox.getModel();
                        if (cbModel.getIndexOf(this.m_currentValue) == -1) {
                            cbModel.addElement(this.m_currentValue);
                        }
                        if (bFieldIsArray && bFieldIsArray != this.m_paramIsArray) {
                            this.m_currentValue = this.m_currentValue + "[1]";
                            if (cbModel.getIndexOf(this.m_currentValue) == -1) {
                                cbModel.addElement(this.m_currentValue);
                            }
                        }
                        this.m_comboBox.setSelectedItem(this.m_currentValue);
                        int nEventType = 511;
                        switch (fieldDef.getFieldType()) {
                            case 32: {
                                nEventType = 506;
                                break;
                            }
                            case 31: {
                                nEventType = 511;
                                break;
                            }
                            case 64: {
                                nEventType = 558;
                                break;
                            }
                            case 128: {
                                nEventType = 563;
                            }
                        }
                        this.m_authPropertyData.resetFieldCache();
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(fieldDef);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, nEventType);
                    }
                    catch (Exception ex1) {
                        VWDebug.logException(ex1);
                        Object var7_9 = null;
                        this.m_comboBox.addActionListener(this);
                        break block16;
                    }
                    Object var7_8 = null;
                    this.m_comboBox.addActionListener(this);
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    this.m_comboBox.addActionListener(this);
                    throw throwable;
                }
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block16;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }
}

